#include "../drivers/gtI2c.h"
#include "../drivers/gtCore.h"
#include "../drivers/ev64360.h"
#include "regFile.h"

// GT64340/60 - Atlantis - Rev 1.0

unsigned int    regFile[] = { //Reg Num   ,Data  
                                // Open C unit's window for device 1
                                0x1400f200,0x1c801d01,
                                0x1400f204,0x07ff0000,
                                0x1400f250,0x0000000e,
                                // Turn on Debug Led 2
                                0x1c810000,0x00000000,
                                // CPU interface: 
                                // 0x40 - 60X Bus, 0x50 - Max Bus
                                0x14000120,0x00000040,
                                0x14000160,0x00000b00,
                                0x14000000,0x020220ff,
                                // Init device parameters
                                // 8 Bit gtFlash 
                                0x1400046c,0x000b5e7f,
                                // 32 bit SRAM 
                                0x1400045c,0xa020509f,
                                // Open DMA windows 0 and 6
                                0x14000a00,0xfff00f01,
                                0x14000a04,0x001f0000,
                                0x14000a30,0x1c001e01,
                                0x14000a34,0x003f0000,
                                0x14000a80,0x000000be,
                                // DMA to copy the 8 bit gtFlash to the boot SRAM
                                // Byte count = 0.5MB 
                                0x14000804,0x80080000,
                                // Source address 
                                0x14000814,0xfff00000,
                                // Destination address
                                0x14000824,0x1c000000,
                                // Next descriptor address
                                0x14000834,0x00000000,
                                0x14000844,0x80001a00,
                                // Dummy writes to stall the system untill the 
                                // DMA finishes
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                0x14000800,0x00000000,
                                // Enable Boot from SRAM
                                0x14000238,0x00001c00,
                                0x14000240,0x0000007f,
                                0x14000028,0x0000ff80,
                                0x14000030,0x0000007f,
                                // Initialize MPP 0-7 for I2C_INIT_ACTIVE
                                0x1400f000,0X02222222,
                                0x1400f004,0X11333011,
                                0x1400f008,0X40431111,
                                0x1400f00c,0X00000044,
                                // End
                                0xffffffff,0xffffffff
                            };
                            
/******************************************************************************
* gtI2cBurnEEPROM - burns a register file to an EEPROM device
*
* Description
* Inputs:   register file array 
* Output:  
* RETURNS: true if burning process ended successfully ,false otherwise.
******************************************************************************/
bool gtI2cBurnEEPROM(unsigned int* regFileTable,I2C_ADDR_RANGE i2cAddrRange,
                     unsigned int deviceAddress) 
{
    I2C_DATA_STRUCT gtI2cDataWrite;
    int             counter=-2;
                                            
    do
    {    
        counter+=2;
#ifdef SWAP_ADDR
        gtI2cDataWrite.data = GT_WORD_SWAP(regFileTable[counter]);
#else
        gtI2cDataWrite.data = regFileTable[counter];
#endif
        /* writing register address */
        gtI2cMasterEEPROMwriteWord(deviceAddress,&gtI2cDataWrite,counter*4,
                                   i2cAddrRange,CNTMR_0); 
        if(gtI2cDataWrite.errorCode != I2C_NO_ERROR)
        {
            printf("\nError Burning register file to I2C...Aborting\n");
            printf("Error Code = %x\n",gtI2cDataWrite.errorCode);
            printf("Status = %x\n",gtI2cDataWrite.status);
            return false;
        }
        else
        {
            printf(".");
        }
        /* writing register data */
#ifdef SWAP_DATA
        gtI2cDataWrite.data = GT_WORD_SWAP(regFileTable[counter+1]);
#else
        gtI2cDataWrite.data = regFileTable[counter+1];
#endif
        gtI2cMasterEEPROMwriteWord(deviceAddress,&gtI2cDataWrite,(counter+1)*4,
                                   i2cAddrRange,CNTMR_0); 
        if(gtI2cDataWrite.errorCode != I2C_NO_ERROR)
        {
            printf("\nError Burning register file to I2C...Aborting\n");
            printf("Error Code = %x\n",gtI2cDataWrite.errorCode);
            printf("Status = %x\n",gtI2cDataWrite.status);
            return false;
        }
        else
        {
            printf(".");
        }
    }while(regFileTable[counter] != 0xffffffff);
    return true;
}
/******************************************************************************
* gtI2cReadEEPROM - read data (words) from EEPROM device starting at offset 0 to 
*                 the given number of words (numberOfWords).                   
*
* Description - data can be read until a specific word address or to the end of
                the regfile (0xffffffff must be sent).  
* Inputs:   number of words to be read ( or 0xffffffff for the whole file )
* Output:  
* RETURNS:  true if Reading process ended successfully,false if Reading process
            failed
******************************************************************************/
bool gtI2cReadEEPROM(unsigned int numberOfWords,I2C_ADDR_RANGE i2cAddrRange,
                     unsigned int deviceAddress)
{
    I2C_DATA_STRUCT     gtI2cDataread;
    unsigned int        counter;
    
    for(counter = 0 ; counter < numberOfWords ; counter++ )
    {
        gtI2cDataread = gtI2cMasterEEPROMreadWord(deviceAddress,counter*4,i2cAddrRange); 
        if(gtI2cDataread.errorCode != I2C_NO_ERROR)
        {
            printf("error in reading address %x\n",counter);
            printf("Status = %x\n",gtI2cDataread.status);
            return false;
        }
        else
        {
#ifdef SWAP_DATA
            printf("Index %d Data = %x\n",counter,GT_WORD_SWAP(gtI2cDataread.data));
#else
            printf("Index %d Data = %x\n",counter,gtI2cDataread.data);
#endif
        }
        if(!(~numberOfWords) && gtI2cDataread.data==0xffffffff)
        {
            counter++;
            gtI2cDataread = gtI2cMasterEEPROMreadWord(deviceAddress,counter*4,i2cAddrRange); 
#ifdef SWAP_DATA
            printf("Index %d Data = %x\n",counter,GT_WORD_SWAP(gtI2cDataread.data));
#else
            printf("Index %d Data = %x\n",counter,gtI2cDataread.data);
#endif
            
            break;               
        }
    }
    return true; 
}
